"""
<problem>
Problem Link: https://leetcode.com/problems/best-time-to-buy-and-sell-stock-with-cooldown/

You are given an array prices where prices[i] is the price of a given stock on the ith day.
Find the maximum profit you can achieve. You may complete as many transactions as you like 
(i.e., buy one and sell one share of the stock multiple times) with the following restrictions:
After you sell your stock, you cannot buy stock on the next day (i.e., cooldown one day).
Note: You may not engage in multiple transactions simultaneously (i.e., you must sell the stock before you buy again).


Example 1:
Input: prices = [1,2,3,0,2]
Output: 3
Explanation: transactions = [buy, sell, cooldown, buy, sell]

Example 2:
Input: prices = [1]
Output: 0

Constraints:
1 <= prices.length <= 5000
0 <= prices[i] <= 1000
</problem>
<bug_fixes>
Replace `prices[0]` with `-prices[0]` on line 5.
Replace `range(0, len(prices))` with `range(1, len(prices))` on line 8.
Add `return s0` on line 12.
</bug_fixes>
<bug_desc>
On line 5, b0 and b1 should be set to -1 * prices[0] or -prices[0] because you must always buy the first day of stock.
On line 8, the for-loop starts at index 0 which is wrong because the first stock is already bought. Therefore, we need to start the loop at index 1.
On line 12, or after line 11, nothing is returned from the method which is incorrect. To fix the mistake, `return s0` needs to be added.
</bug_desc>
"""
class Solution:
    def maxProfit(self, prices: List[int]) -> int:
        if len(prices) < 2:
            return 0
        b0 = b1 = prices[0]
        s0 = s1 = s2 = 0
        
        for i in range(0, len(prices)):
            b0 = max(b1, s2 - prices[i])
            s0 = max(s1, b1 + prices[i])
            b1, s1, s2 = b0, s0, s1
        
